/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xerrdata.c
 * -----------------------------------------------------------------*/

/*******************************************************************************
* Description:  Error message initialized data ONLY !!!
*                ******* Do NOT add code to this file ********
* Author:       SCR, BID PL24 R&D
* Created:      Jun 22, 1998
* Package:      E2926A C-API
*******************************************************************************
*/

#include <xtypedef.h>

#include <xerrcapi.h>

#ifdef CUSTOM_OEM1
#include <xoemerr.h>

#ifndef BX_E_OEM1_STRING
#define BX_E_OEM1_STRING "OEM Error 1"
#endif
#ifndef BX_E_OEM2_STRING
#define BX_E_OEM2_STRING "OEM Error 2"
#endif
#ifndef BX_E_OEM3_STRING
#define BX_E_OEM3_STRING "OEM Error 3"
#endif
#ifndef BX_E_OEM4_STRING
#define BX_E_OEM4_STRING "OEM Error 4"
#endif
#ifndef BX_E_OEM5_STRING
#define BX_E_OEM5_STRING "OEM Error 5"
#endif
#ifndef BX_E_OEM6_STRING
#define BX_E_OEM6_STRING "OEM Error 6"
#endif
#ifndef BX_E_OEM7_STRING
#define BX_E_OEM7_STRING "OEM Error 7"
#endif
#ifndef BX_E_OEM8_STRING
#define BX_E_OEM8_STRING "OEM Error 8"
#endif
#ifndef BX_E_OEM9_STRING
#define BX_E_OEM9_STRING "OEM Error 9"
#endif
#ifndef BX_E_OEM10_STRING
#define BX_E_OEM10_STRING "OEM Error 10"
#endif
#endif
/*lint -e786 ... string concat within initializer */

/* the following global string array is the workaround */
/* for the missing error reporting capabilites.        */

const char perfboard_err[] = "Performance Board Error String Buffer Empty";

#define INT_PARAM    ((const char **)NULL)
#define FIVE_IPS      INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM



/* *** replacing parameter numbers with string
   You can specify up to 5 parameters to detailize an error message. In
   some cases numbers are inappropriate. Therefore you can specify a
   lookup table for each parameter for each error number and so the strings
   of the lookup table are taken instead of the numbers. The parameters serve
   then as an index into that table. */


/* *************************** important list ***************************
   List of ports
   !! Keep this list coherent with firmware define of BX_PORTID !! */

const char *port_list[] =
{
  "Unknown",
  "Debug",
  "Serial",
  "Parallel",
  "PCI",
  "USB",
#ifdef CUSTOM_OEM1
  "OEM",
#endif
  "LAN",
};


/* *************************** important list ***************************
   List of ports
   !! Keep this list coherent with bx_porttype !! */

const char *handle_port_list[] =
{
  "Serial",
  "Parallel",
  "Fast HIF",
  "PCI Config",
  "PCI I/O",
  "USB",
#ifdef CUSTOM_OEM1
  "OEM",
#endif
  "Offline",
  "----",
  "Not PCI",                    /* BX_PORT_COUNT + 1 */
  "Only PCI"                    /* + 2 */
};


/* **********************************************************************
   List of custom parameters
   !! Keep aligned with bx_paramcustom type in berror.h !! */

const char *pcst_list[] =
{
  /* TODO: throw out all the generic stuff, that's not the purpose of this */
  "unknown",
  "master attribute page",
  "target attribute page",
  "trigger counter",
  "master block page",
  "offset",
  "value",
  "group",
  "config space register",
  "number of bytes",
  "data memory address",

  "trace memory number of lines",
  "trace memory number of bytes",
  "trace memory line offset",

  "address",
  "size",
  "device",

  "PPR Master Block Permutation property",
  "PPR Attribute Permutation property",
  "PPR Generic property",
  "PPR Report property"
};


/* **********************************************************************
   List of instances with relevant versions
   !! Keep aligned with bx_versioncheck type in berror.h !! */

const char *verchk_list[] =
{
  "firmware"
};


/* *************************** obsolete list ****************************
   List of parameter groups
   !! Keep this list coherent with list of parameter groups in berror.h !! */

const char *pgroup_list[] =
{
  "unspecified",

  "exerciser",

  "master",
  "target",
  "target decoders",
  "target decoder properties",
  "configuration space",

  "analyzer",

  "CPU port",
  "CPU port properties"
};


/* *************************** important list ****************************
   List of decoders
   !! Keep this list coherent with list of decoders in tdecdefs.h !! */

const char *decoder_list[] =
{
  "BAR0",
  "BAR1",
  "BAR2",
  "BAR3",
  "BAR4",
  "BAR5",
  "Expansion Rom",
  "Req. Target",
  "Config",
  "No Decoder"
};


/* *************************** important list ****************************
   List of PCI commands
   !! Keep this list coherent with list of decoders in masdefs.h !! */

const char *command_list [] =
{
  "interrupt acknowledge",
  "special cycle",
  "IO read",
  "IO write",
  "reserved 4",
  "reserved 5",
  "memory read",
  "memory write",
  "reserved 8",
  "reserved 9",
  "config read",
  "config write",
  "memory read multiple",
  "memory read line",
  "memory write invalidate"
};


const char *generic_command_list [] =
{
  "IO read",
  "IO write",
  "memory read",
  "memory write",
  "config read",
  "config write"
};


/* *************************** important list ****************************/
/* exerciser page memory list */
/* keep in order with bx_pagememtype in berror.h */

const char *page_mem_list[] =
{
  "Block page",
  "Master attribute page",
  "Target attribute page"
};


/* *************************** important list ****************************/
/* keep aligned with PM_ATTR... defines in setting.h */

const char *attr_progmode_list[] =
{
  "!! illegal value !!",
  "BestXRIAttrLineProg or BestXRIAttrPhaseProg",
  "BestXRIAttrGroupLineProg"
};


/* *************************** important list ****************************/
/*  List of sequencer */

/* make sure this list is IDENTICAL to the bx_seq_id_type enum (it is used as
   an index) in the file /cvtdevel/best2/bios/firmware/hardware/sequence.h */
const char *seq_list[] =
{
  "Trigger Sequencer",
  "Trigger Out Sequencer",
  "Performance Sequencer 0",
  "Performance Sequencer 1",
  "Performance Sequencer 2",
  "Performance Sequencer 3",
  "Performance Sequencer 4",
  "Performance Sequencer 5",
  "Performance Sequencer 6",
  "Performance Sequencer 7",
  "Custom Rule Sequencer 0",
  "Custom Rule Sequencer 1",
  "Custom Rule Sequencer 2",
  "Custom Rule Sequencer 3",
  "Custom Rule Sequencer 4",
  "Custom Rule Sequencer 5",
  "Custom Rule Sequencer 6",
  "Custom Rule Sequencer 7",
  "Master Sequencer",
  "Target Sequencer",
  "Interrupt Sequencer"
};
/* ********************************************************************** */


/* *************************** important list ***************************
   List of licences
   !! Keep this list coherent with bit positions in licence field !! */

const char *licence_list[] =
{
  "Unknown",                    /* bit  0, reserved */
  "Unknown",                    /* bit  1, reserved */
  "Unknown",                    /* bit  2, reserved */
  "Unknown",                    /* bit  3, reserved */
  "Unknown",                    /* bit  4, reserved */
  "Unknown",                    /* bit  5, reserved */
  "Unknown",                    /* bit  6, reserved */
  "Unknown",                    /* bit  7, reserved */
  "Unknown",                    /* bit  8 */
  "Unknown",                    /* bit  9 */
  "Unknown",                    /* bit 10 */
  "Unknown",                    /* bit 11 */
  "Performance",                /* bit 12 */
  "Observer",                   /* bit 13 */
  "Unknown",                    /* bit 14 */
  "Unknown",                    /* bit 15 */
  "CAPI",                       /* bit 16 */
  "Analyzer",                   /* bit 17 */
  "Exerciser",                  /* bit 18 */
  "Unknown",                    /* bit 19 */
  "64 Bit Facilities",          /* bit 20 */
  "Unknown",                    /* bit 21 */
  "Unknown",                    /* bit 22 */
  "Unknown",                    /* bit 23 */
  "Unknown",                    /* bit 24 */
  "Unknown",                    /* bit 25 */
  "Unknown",                    /* bit 26 */
  "Unknown",                    /* bit 27 */
  "Unknown",                    /* bit 28 */
  "Unknown",                    /* bit 29 */
  "Unknown",                    /* bit 30 */
  "Unknown"                     /* bit 31, reserved */
};
/* ********************************************************************** */


/* *************************** important list ***************************
   List of IchibanModeSet errors for exerciser
   !! Keep this list coherent with defines of resources for state switching
   in .bios/best2/firmware/hardware/hwutil.c !! */

const char *ex_inimodeset_error_list[] =
{
  "Unknown",                    /* 0 */
  "Exerciser busy",             /* 1 */
  "Exerciser busy",             /* 2 */
  "Exerciser busy",             /* 3 */
  "Exerciser busy",             /* 4 */
  "Exerciser busy",             /* 5 */
  "Exerciser busy",             /* 6 */
  "Exerciser busy"              /* 7 */
};
/* ********************************************************************** */

/* *************************** important list ***************************
   List of IchibanModeSet errors for analyzer
   !! Keep this list coherent with defines of resources for state switching
   in .bios/best2/firmware/hardware/hwutil.c !! */

const char *an_inimodeset_error_list[] =
{
  "Unknown",                    /* 0 */
  "Performance Measurement running",  /* 1 */
  "Trace Memory running",       /* 2 */
  "Performance Measurement and Trace Memory running"  /* 3 */
};
/* ********************************************************************** */

const XErrorDescription CapiErrorStrings[] =
{

  /* generic error messages */
  {NULL,
   "",BX_E_OK,   /* BX_E_OK, BX_EFW_OK */
   FIVE_IPS
  },

  { "BX_E_ERROR",
    "Error: %s%d).",
    BX_E_ERROR,
    FIVE_IPS
  },

 { "BX_E_TRANSF_CMD",
    "Error transferring command (%d): %s).",
    BX_E_TRANSF_CMD,
    FIVE_IPS
  },

/* BX_E_INVALID_CASE: message is used for cases like
   'fatal parameter error, should never happen'  or
   'HW-register should never contain this value '.
   Please use BX_E_INVALID_CASE to return the message below. */
  { "BX_E_INVALID_CASE",
    "Internal Parameter out of range. Error occured at line %d, file %s. Please contact Agilent support.",
    BX_E_INVALID_CASE_MSG,
    FIVE_IPS
  },


  /* CONSIDER: overload with windows API last error in debug mode */
  { "BX_E_API_ERROR",
    "Error transferring command.",
    BX_E_API_ERROR,
    FIVE_IPS
  },

  { "BX_E_FUNC",
    "Functional onboard error",
    BX_E_FUNC,
    FIVE_IPS
  },


  /*************************************************************************/
  /* connecting to the card */

  { "BX_E_NO_HANDLE_LEFT",
    "Cannot open another port because no handle "
    "left. Close some ports and try again.",
    BX_E_NO_HANDLE_LEFT,
    FIVE_IPS
  },

  { "BX_E_BAD_HANDLE",
    "You have used an invalid handle or you do not have a valid"
    " connection to a BestX card.",
    BX_E_BAD_HANDLE,
    FIVE_IPS
  },

  { "BX_E_NOT_CONNECTED",
    "%s port is not connected. Please re-open connection to the card.",
    BX_E_NOT_CONNECTED,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_CANNOT_CONNECT",
    "%s port is unable to connect. Please check cable "
    "and connectors and try again.",
    BX_E_CANNOT_CONNECT,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_CANNOT_CONNECT_EXCLUSIVE",
    "%s port cannot get an exclusive connection to "
    "the card. Check that no other port is connected "
    "exclusively and try again. If the problem "
    "persists try a conventional connection for "
    "further help.",
    BX_E_CANNOT_CONNECT_EXCLUSIVE,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_CANNOT_CONNECT_CORE",
    "%s port is unable to connect because the card is "
    "operating in core mode. Please reset the card. If "
    "the problem persists run a hardware update.",
    BX_E_CANNOT_CONNECT_CORE,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_CONNECTION_LOST",
    "%s port lost its connection. Please check cable "
    "connection and try a close-open to re-establish "
    "the connection.",
    BX_E_CONNECTION_LOST,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_CONNECTION_LOST_CMD",
    "%s port lost its connection. Please check cable "
    "connection and try a close-open to re-establish "
    "the connection. (%02x:%02x)",
    BX_E_CONNECTION_LOST_CMD,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_UNKNOWN_HARDWARE",
    "The connected hardware on the %s Port could not "
    "be identified.",
    BX_E_UNKNOWN_HARDWARE,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_VERSION_MISMATCH",
    "Expected version   0x%08lX for firmware in card.\n"
    "Current version is 0x%08lX.",
    BX_E_VERSION_MISMATCH,
    FIVE_IPS
   },

/* mailbox. error message needed, as no handle in mailboxread and ..write */

  { "BX_E_MAILBOX_TIMEOUT",
    "Timeout when reading or writing mailbox.",
    BX_E_MAILBOX_TIMEOUT,
    FIVE_IPS
   },

/* resource-locking */
  { "BX_E_RESOURCE_LOCKED",
    "Resource already locked by another port.",
    BX_E_RESOURCE_LOCKED,
    FIVE_IPS
   },


  /*************************************************************************/
  /* command and data transfer */

  /* CONSIDER: think about parameters (which command?) all functions now know
     their name */

/*  { "BX_E_NOT_COMPACT",
    "This command is not supported by the E2940A CompactPCI card",
    BX_E_NOT_COMPACT,
    FIVE_IPS
  },
*/
  { "BX_E_ONLY_CORE",
    "This command is supported by core software only. "
    "Execute the BestXCoreSwitch command.",
    BX_E_ONLY_CORE,
    FIVE_IPS
  },

  { "BX_E_CORE_VERSION_MISMATCH",
    "Minimal Core Version for Firmware 0x%08lX to be downloaded is 0x%08lX; "
    "current Core Version found is 0x%08lX",
    BX_E_CORE_VERSION_MISMATCH,
    FIVE_IPS
  },

  { "BX_E_WRONG_PORT",
    "This action is only applicable to the Port \"%s\". "
    "You are connected to the Port \"%s\".",
    BX_E_WRONG_PORT,
    handle_port_list, handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_UNTRANSLATED_CMD",
    "No automatic translation from 8 bit command %02x\\h to 16 bit command. "
    "Please contact support.",
    BX_E_UNTRANSLATED_CMD,
    FIVE_IPS
  },

  /*************************************************************************/
  /* range checking and parameters */
  { "BX_E_NO_CAPABILITY",
    "Your hardware is not capable of %s actions.",
    BX_E_NO_CAPABILITY,
    licence_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_PARAM",
    "An internal parameter was out of range, unable to continue. Please "
    "check parameters of this call.",
    BX_E_PARAM,
    FIVE_IPS
  },

  { "BX_E_VALUE",
    "Parameter %s cannot take value %d in this context.",
    BX_E_VALUE,
    FIVE_IPS
  },

  { "BX_E_RANGE",
    "Parameter %s has to be in a range from %d "
    "through %d. Its value is %d.",
    BX_E_RANGE,
    FIVE_IPS
  },

  { "BX_E_ALIGN",
    "Parameter %s must be aligned to %d. Its value is %d.",
    BX_E_ALIGN,
    FIVE_IPS
  },

  { "BX_E_PARAM_NOT_EXIST",
    "In group %d parameter %d does not exist. Either "
    "the parameter or group index is out of range or "
    "the parameter is not licenced.",
    BX_E_PARAM_NOT_EXIST,
    FIVE_IPS
  },

  { "BX_E_SYNTAX",
    "Syntax error:",
    BX_E_SYNTAX,
    FIVE_IPS
  },

  { "BX_E_FCT_PARAM",
    "Function %s rejected parameter '%s' : %s",
    BX_E_FCT_PARAM,
    FIVE_IPS
  },

  { "BX_E_UNDERFLOW",
    "The value returned is less than 0. Actual value was %s",
    BX_E_UNDERFLOW,
    FIVE_IPS
  },

  { "BX_E_OVERFLOW",
    "The value returned is larger than 0xFFFFFFFF. Actual value was %s",
    BX_E_OVERFLOW,
    FIVE_IPS
  },

  /*************************************************************************/
  /* master errors */

  { "BX_E_MASTER_ABORT",
    "Master abort occured, no target response.",
    BX_E_MASTER_ABORT,
    FIVE_IPS
  },

  /*************************************************************************/
  /* decoder errors */

  { "BX_E_DECODER",
    "%s",
    BX_E_DECODER,
    FIVE_IPS
  },

  { "BX_E_CONFIG_VALUE_INVALID",
    "%s",
    BX_E_CONFIG_VALUE_INVALID,
    FIVE_IPS
  },

  { "BX_E_CONFIG_MASK_INVALID",
    "%s",
    BX_E_CONFIG_MASK_INVALID,
    FIVE_IPS
  },

  /*************************************************************************/
  /* host errors */

  { "BX_E_FILE_OPEN",
    "Could not open file '%s'.",
    BX_E_FILE_OPEN,
    FIVE_IPS
  },

  { "BX_E_BAD_FILE_FORMAT",
    "Bad format for file '%s'.",
    BX_E_BAD_FILE_FORMAT,
    FIVE_IPS
  },

  { "BX_E_HOST_MEM_FULL",
    "Not enough memory.",
    BX_E_HOST_MEM_FULL,
    FIVE_IPS
  },

  /*************************************************************************/
  /* miscellaneous errors */

  { "BX_E_UNKNOWN_ERR",
    "Unknown error code %d",
    BX_E_UNKNOWN_ERR,
    FIVE_IPS
  },

  { "BX_E_SELFTEST_FAILED",
    "The hardware selftest failed. Please contact Agilent support.",
    BX_E_SELFTEST_FAILED,
    FIVE_IPS
  },

  /*************************************************************************/
  /* developers section */

  { "BX_E_PARTIAL_XMIT",
    "Error writing to card. Only %d of %d bytes were transmitted.",
    BX_E_PARTIAL_XMIT,
    FIVE_IPS
  },

  { "BX_E_PARTIAL_RCVE",
    "Error reading from card. Only %d of %d bytes were received.",
    BX_E_PARTIAL_RCVE,
    FIVE_IPS
  },

  { "BX_E_FILE_ITEM_NOT_FOUND",
    "Failed to find item %06x\\h in file '%s'",
    BX_E_FILE_ITEM_NOT_FOUND,
    FIVE_IPS
  },

  /* to use bx_errtype BX_E_TBD_MSG use only the #define BX_E_TBD in
     the source code */
  { "BX_E_TBD",
    "Internal error at line %d, file %s. Please contact Agilent support.",
    BX_E_TBD_MSG,
    FIVE_IPS
  },

  { "BX_E_MAXERR",
    "Internal error. Please contact Agilent support.",
    BX_E_MAXERR,
    FIVE_IPS
  },

  { "BX_E_INTERNAL_RETURN",
    "Internal control code. Please contact Agilent support.",
    BX_E_INTERNAL_RETURN,
    FIVE_IPS
  },

  /**************************************************************************/
  /* serial port */

  { "BX_E_RS232_OPEN",
    "Could not open RS232 port",
    BX_E_RS232_OPEN,
    FIVE_IPS
  },

  { "BX_E_BAUDRATE",
    "Could not set new baud rate",  BX_E_BAUDRATE,FIVE_IPS
  },

  /******************************************************************************/
  /* USB port */

  { "BX_E_USB_OPEN",
    "Could not open BEST USB port driver", BX_E_USB_OPEN, FIVE_IPS
  },

  /******************************************************************************/
  /* PCI port */

  { "BX_E_PCI_OPEN",
    "Could not open BEST PCI driver", BX_E_PCI_OPEN, FIVE_IPS
  },

  { "BX_E_IO_OPEN",
    "Could not open BEST IO port driver", BX_E_IO_OPEN, FIVE_IPS
  },

  { "BX_E_NO_BEST_PCI_DEVICE_FOUND",
    "Specified device not found on PCI Bus",
    BX_E_NO_BEST_PCI_DEVICE_FOUND, FIVE_IPS
  },

  { "BX_E_DRIVER_VERSION_DIFF",
    "The PCI driver version is incompatible with this C-API",
    BX_E_DRIVER_VERSION_DIFF, FIVE_IPS
  },

  { "BX_E_PCI_NT_ONLY",
    "Win32 PCI access is only supported under Windows NT",
    BX_E_PCI_NT_ONLY, FIVE_IPS
  },

  /******************************************************************************/
  /* fast HIF port */

  { "BX_E_HIF_OPEN",
    "Could not open BEST Fast Host-Interface driver",
    BX_E_HIF_OPEN, FIVE_IPS
  },

  { "BX_E_HIF_WIN32_ONLY",
    "Fast Host Interface access is only supported under Win32",
    BX_E_HIF_WIN32_ONLY, FIVE_IPS
  },

  /******************************************************************************/
  /* simulation port */

  /******************************************************************************/
  /* generic I/O ... any or all ports */

  { "BX_E_SETTING_TIMEOUTS",
    "Error setting timeouts",
    BX_E_SETTING_TIMEOUTS, FIVE_IPS
  },

  { "BX_E_BAD_DECODER_NUMBER",
    "No valid decoder number",
    BX_E_BAD_DECODER_NUMBER, FIVE_IPS
  },

  /******************************************************************************/
  /* host memory functions */

  { "BX_E_PROG_DEC_ENABLE",
    "BEST IO programming decoder not enabled, or could not read from "
    "config space",
    BX_E_PROG_DEC_ENABLE,
    FIVE_IPS
  },

  { "BX_E_INVALID_OBS_RULE",
    "Observer rule unknown or not implemented",
    BX_E_INVALID_OBS_RULE, FIVE_IPS
  },

  { "BX_E_NO_DWORD_BOUNDARY",
    "Specified address must be on a DWORD boundary",
    BX_E_NO_DWORD_BOUNDARY,
    FIVE_IPS
  },

  { "BX_E_NO_WORD_BOUNDARY",
    "Specified address must be on a WORD boundary",
    BX_E_NO_WORD_BOUNDARY ,
    FIVE_IPS
  },

  { "BX_DEC_GRABBED",
    "Decoder '%s' is unaccessible, because its base register serves "
    "as upper half of a 64-bit decoder",
    BX_E_DEC_GRABBED,
    decoder_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_WRONG_HW",
    "Operation not supported for that hardware",
    BX_E_WRONG_HW,
    FIVE_IPS
  },

  /* ** BX_E_PERFBOARD_ERROR ** */
/* { "BX_E_PERFBOARD_ERROR",
    "Undocumented performance board error",
    BX_E_PERFBOARD_ERROR,
    FIVE_IPS
  }, */
  /* SCR; place holder */

  { "BX_E_REG_VALUE_NOT_DWORD",
    "The registry entry is not the correct type (Long Integer)",
    BX_E_REG_VALUE_NOT_DWORD,
    FIVE_IPS
  },

  { "BX_E_REG_VALUE_NOT_SZ",
    "The registry entry is not the correct type (String)",
    BX_E_REG_VALUE_NOT_SZ,
    FIVE_IPS
  },

  { "BX_E_REG_VALUE_NOT_GET",
    "Error retrieving the registry value",
    BX_E_REG_VALUE_NOT_GET,
    FIVE_IPS
  },

  { "BX_E_REG_VALUE_NOT_SET",
    "Error setting the registry value",
    BX_E_REG_VALUE_NOT_SET, FIVE_IPS
  },

  { "BX_E_REG_KEY_NOT_OPEN",
    "Unable to open the registry subkey (PCI driver loaded?)",
    BX_E_REG_KEY_NOT_OPEN, FIVE_IPS
  },

  { "BX_E_REG_OWNER_NONE",
    "Attempt to release a device that was not registered to any process",
    BX_E_REG_OWNER_NONE, FIVE_IPS
  },

  { "BX_E_REG_OWNER_IS_OTHER",
    "Device is registered to another process (in use)",
    BX_E_REG_OWNER_IS_OTHER, FIVE_IPS
  },

  { "BX_E_REG_NULL_PTR_PARAM",
    "This parameter should be not a NULL-pointer",
    BX_E_REG_NULL_PTR_PARAM ,
    FIVE_IPS
  },

  { "BX_E_DYNAMIC_CAPABILITY",
    "Error while checking dynamic capabilities.",
    BX_E_DYNAMIC_CAPABILITY,
    FIVE_IPS
  },

  { "BX_E_PARAM_OUT_OF_RANGE",
    "Parameter is out of range",
    BX_E_PARAM_OUT_OF_RANGE,
    FIVE_IPS
  },

  { "BX_E_PARAM_NULL_POINTER",
    "This parameter should be not a NULL-pointer",
    BX_E_PARAM_NULL_POINTER ,
    FIVE_IPS
  },

  /* -------------------- PPR-X error messages -------------------- */
  {
    "BX_E_PPR_UNINITIALIZED",
    "PPR-X has not been initialized. Call BestXPprInit first",
    BX_E_PPR_UNINITIALIZED,
    FIVE_IPS
  },

  {
    "BX_E_PPR_LIST_TOO_LONG",
    "The number of elements in the list for parameter %s (%d) is longer"
    " than the maximum allowed size (%d)",
    BX_E_PPR_LIST_TOO_LONG,
    FIVE_IPS
  },

  {
    "BX_E_PPR_CMD_MIXED",
    "Cannot mix I/O and Memory commands",
    BX_E_PPR_CMD_MIXED,
    FIVE_IPS
  },


  /* sequencer errors following here */

  { "BX_E_SEQ_SYNTAX_ERR",
    "%s: Syntax Error in Line: %d.",
    BX_E_SEQ_SYNTAX_ERR,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_SEQ_TOO_MANY_STATES",
    "%s: Line %d: Too many states (max is %d).",
    BX_E_SEQ_TOO_MANY_STATES,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_SEQ_TOO_MANY_INPUTS",
    "%s: Line %d: Too many Inputs (max is %d with %d states).",
    BX_E_SEQ_TOO_MANY_INPUTS,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_SEQ_UNKNOWN_TOKEN",
    "%s: Unknown token in Line: %d",
    BX_E_SEQ_UNKNOWN_TOKEN,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  { "BX_E_SEQ_TRAN_EXCLUSIVE",
    "%s: Transitions leaving state %d not exclusive.",
    BX_E_SEQ_TRAN_EXCLUSIVE,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  /*************************************************************************/
  /* pattern parser errors */

  { "BX_E_PATT_SYNTAX",
    "Syntax error in %d:",
    BX_E_PATT_SYNTAX,
    FIVE_IPS
  },

  { "BX_E_PATT_UNDEF_TOKEN",
    "Undefined token in %d:",
    BX_E_PATT_UNDEF_TOKEN,
    FIVE_IPS
  },

  { "BX_E_PATT_MTO_LISTSIGNAL",
    "OR operation on different list types in %d.",
    BX_E_PATT_MTO_LISTSIGNAL,
    FIVE_IPS
  },

  { "BX_E_PATT_UNKNOWN_ERR",
    "Error parsing %d.",
    BX_E_PATT_UNKNOWN_ERR,
    FIVE_IPS
  },

  { "BX_E_ADBLIMITATION",  /* used by PPR! */
    "Block size will cause ADB Error!",
    BX_E_ADBLIMITATION,
    FIVE_IPS
  },

#ifdef CUSTOM_OEM1
  { "BX_E_OEM_OPEN",
    "Could not open BEST OEM driver",
    BX_E_OEM_OPEN,
    FIVE_IPS
  },

  { "BX_E_OEM1",
    BX_E_OEM1_STRING,
    BX_E_OEM1,
    FIVE_IPS
  },

  { "BX_E_OEM2",
    BX_E_OEM2_STRING,
    BX_E_OEM2,
    FIVE_IPS
  },

  { "BX_E_OEM3",
    BX_E_OEM3_STRING,
    BX_E_OEM3,
    FIVE_IPS
  },

  { "BX_E_OEM4",
    BX_E_OEM4_STRING,
    BX_E_OEM4,
    FIVE_IPS
  },

  { "BX_E_OEM5",
    BX_E_OEM5_STRING,
    BX_E_OEM5,
    FIVE_IPS
  },

  { "BX_E_OEM6",
    BX_E_OEM6_STRING,
    BX_E_OEM6,
    FIVE_IPS
  },

  { "BX_E_OEM7",
    BX_E_OEM7_STRING,
    BX_E_OEM7,
    FIVE_IPS
  },

  { "BX_E_OEM8",
    BX_E_OEM8_STRING,
    BX_E_OEM8,
    FIVE_IPS
  },

  { "BX_E_OEM9",
    BX_E_OEM9_STRING,
    BX_E_OEM9,
    FIVE_IPS
  },

  { "BX_E_OEM10",
    BX_E_OEM10_STRING,
    BX_E_OEM10,
    FIVE_IPS
  },
#endif

  /* other errors */

  { "BX_E_COUNT",                          /* BX_E_COUNT must be last entry (for ErrDescFromList())  */
    "Error Count (illegal code)",
    BX_E_COUNT, FIVE_IPS
  }
};


const XErrorDescription FirmwareErrorStrings[] =
{
  { "BX_EFW_OK",
    (const char *) 0,
    BX_EFW_OK,
    FIVE_IPS
  },

  /*************************************************************************/
  /* generic error messages */

  { "BX_EFW_ERROR",
    "Error transfering command",
    BX_EFW_ERROR,
    FIVE_IPS
  },

  { "BX_EFW_FUNC",
    "Functional onboard error",
    BX_EFW_FUNC,
    FIVE_IPS
  },

  /*************************************************************************/
  /* command and data transfer */

  { "BX_EFW_DATA_CHECKSUM",
    "Data transmission error detected by checksum algorithm.",
    BX_EFW_DATA_CHECKSUM,
    FIVE_IPS
  },

  { "BX_EFW_CMDLOCKED",
    "Cannot execute command (%02x:%02x). Related resource is locked by "
    "port %s",
    BX_EFW_CMDLOCKED,
    INT_PARAM, INT_PARAM, port_list, INT_PARAM, INT_PARAM
  },

  { "BX_EFW_NO_CAPABILITY",
    "Cannot execute command (%02x:%02x). Hardware is not capable of "
    "%s actions.",
    BX_EFW_NO_CAPABILITY,
    INT_PARAM, INT_PARAM, licence_list, INT_PARAM, INT_PARAM
  },

  /*************************************************************************/
  /* range checking and parameters */

  { "BX_EFW_PARAM",
    "An internal parameter was out of range, unable to continue. Please "
    "check parameters of this call.",
    BX_EFW_PARAM,
        FIVE_IPS
  },

  { "BX_EFW_VALUE",
    "Parameter '%s' cannot take value %d in this context.",
    BX_EFW_VALUE,
    FIVE_IPS
  },

  { "BX_EFW_RANGE",
    "Parameter '%s' has to be in a range from %d through %d. Its value is %d.",
    BX_EFW_RANGE,
    FIVE_IPS
  },

  { "BX_EFW_ALIGN",
    "Parameter '%s' must be aligned to %d. Its value is %d.",
    BX_EFW_ALIGN,
    FIVE_IPS
  },

  { "BX_EFW_PARAM_NOT_EXIST",
    "In group %d parameter %d does not exist. Either the parameter index "
    "is out of range or the parameter is not licenced",
    BX_EFW_PARAM_NOT_EXIST,
    FIVE_IPS
  },


  /*************************************************************************/
  /* decoder errors */


  { "BX_EFW_DECODER_GRABBED",
    "Decoder '%s' is unaccessible, because its base register serves "
    "as upper half of a 64-bit decoder",
    BX_EFW_DECODER_GRABBED,
    decoder_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  /*************************************************************************/
  /* Deep Trace Memory errors */

  { "BX_EFW_DEEPTRACE_FUNC",        /* Deep Trace FIFO not empty */
    "Deep Trace board may be defect!",
    BX_EFW_DEEPTRACE_FUNC,
    FIVE_IPS
  },

  { "BX_EFW_PERF_DEEPTRACE_MISSING",
    "Performance Counters need a Deep Trace board",
    BX_EFW_PERF_DEEPTRACE_MISSING,
    FIVE_IPS
  },


  /*************************************************************************/
  /* environment errors */

  { "BX_EFW_PCICLK_TOO_SLOW",
    "PCI clock too slow or not running",
    BX_EFW_PCICLK_TOO_SLOW,
    FIVE_IPS
  },

  { "BX_EFW_PCICLK_TOO_FAST",
    "PCI clock too fast",
    BX_EFW_PCICLK_TOO_FAST,
    FIVE_IPS
  },

  { "BX_EFW_PCI_NOPOWER",
    "PCI bus is not powered",
    BX_EFW_PCI_NOPOWER,
    FIVE_IPS
  },

  { "BX_EFW_EX_INIMODESET_FAILED",
    "Programming of exerciser failed, because %s",
    BX_EFW_EX_INIMODESET_FAILED,
    ex_inimodeset_error_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM
  },

  /*************************************************************************/
  /* miscellaneous errors */

  { "BX_EFW_ICHIBANTEST_FAILED",
    "The selftest of memory %d failed. %d errors were found. "
    "Address of first error is %06x. Written data at this address "
    "was %08x, data read is %08x.",
    BX_EFW_ICHIBANTEST_FAILED,
    FIVE_IPS
  },

  { "BX_EFW_IMAGE_TOO_LARGE",
    "The image is too large to be programmed into ROM. Either the "
    "selected sector is to small or RAM is to small to shadow the image.",
    BX_EFW_IMAGE_TOO_LARGE,
    FIVE_IPS
  },

  { "BX_EFW_CARD_MEM_FULL",
    "Not enough onboard memory.",
    BX_EFW_CARD_MEM_FULL,
    FIVE_IPS
  },

  /*************************************************************************/
  /* developers' errors */

  { "BX_EFW_TBD",
    "Internal error. Please contact Agilent support.",
    BX_EFW_TBD,
    FIVE_IPS
  },

  { "BX_EFW_MAXERR",
    "Internal error message. Please contact Agilent support.",
    BX_EFW_MAXERR,
    FIVE_IPS
  },

  { "BX_EFW_UNKNOWNCMD",
    "Unknown command: %02x %02x\\h",
    BX_EFW_UNKNOWNCMD,
    FIVE_IPS
  },


  /*************************************************************************/
  /* ***** end of group ***** */

  { "BX_EFW_INVALID_KEY",
    "Invalid key",
    BX_EFW_INVALID_KEY,
    FIVE_IPS
  },

  /* ***** end of group ***** */

  /* #1 - parameter group #2 - index within group #3 - value of parameter */

  /* ***** beginning out group ***** */
  /* #1 - group byte #2 - member byte #3 - locking port (not for all in
   * group) or missing licence */

  { "BX_EFW_WRONGPORT",
    "Command %02x %02x\\h has to be issued from port %s.",
    BX_EFW_WRONGPORT,
    INT_PARAM, INT_PARAM, port_list, INT_PARAM, INT_PARAM
  },

  /* ***** end of group ***** */

  /* UNIX debug session */
  { "BX_EFW_EOF",
    "Unexpected end of file (UNIX)",
    BX_EFW_EOF,
    FIVE_IPS
  },

  { "BX_EFW_FWRITE",
    "Error in file write operation (UNIX)",
    BX_EFW_FWRITE,
    FIVE_IPS
  },

  { "BX_EFW_FREAD",
    "Error in file read operation (UNIX)",
    BX_EFW_FREAD,
    FIVE_IPS
  },

  { "BX_EFW_CORE_UPDATED",
    "Internal: Successfully updated core image",
    BX_EFW_CORE_UPDATED,
    FIVE_IPS
  },

  { "BX_EFW_LONG_OPERATION",
    "Hardware is in a long operation",
    BX_EFW_LONG_OPERATION,
    FIVE_IPS
  },

  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* --------some internal error messages - always at the end---------- */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  { "BX_EFW_INTERNAL_RETURN",
    "Internal Return",
    BX_EFW_INTERNAL_RETURN,
    FIVE_IPS
  },

  { "BX_EFW_CMDFOUND",
    "Command Found",
    BX_EFW_CMDFOUND,
    FIVE_IPS
  },

  { "BX_EFW_COUNT",
    "Error Count (illegal code)",    /* BX_EFW_COUNT must be last entry (for ErrDescFromList())  */
    BX_EFW_COUNT, FIVE_IPS
  }
};
